/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.math.BigDecimal;
import org.egov.infra.exception.ApplicationRuntimeException;

public final class MoneyUtils {
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final int DECIMALS = 0;
    private static final int DECIMALS2 = 2;
    private static final int ROUNDING_MODE = 4;

    private MoneyUtils() {
    }

    public static long[] allocate(long amountInPaise, long[] weights) {
        int i;
        if (weights.length == 0) {
            return new long[]{amountInPaise};
        }
        long[] splits = new long[weights.length];
        long totalWeight = 0L;
        for (long weight : weights) {
            totalWeight += weight;
        }
        if (totalWeight == 0L) {
            throw new ApplicationRuntimeException("Total of weight can not be zero");
        }
        long remainder = amountInPaise;
        for (i = 0; i < splits.length; ++i) {
            splits[i] = amountInPaise * weights[i] / totalWeight;
            remainder -= splits[i];
        }
        i = 0;
        while ((long)i < remainder) {
            splits[i] = splits[i] + 1L;
            ++i;
        }
        return splits;
    }

    public static BigDecimal[] allocate(BigDecimal amountInRupees, long[] weights) {
        if (amountInRupees == null) {
            return new BigDecimal[0];
        }
        BigDecimal[] resultInRupees = new BigDecimal[weights.length];
        long amountInPaise = MoneyUtils.roundAndConvertToPaise(amountInRupees);
        long[] resultsInPaise = MoneyUtils.allocate(amountInPaise, weights);
        for (int i = 0; i < resultsInPaise.length; ++i) {
            resultInRupees[i] = BigDecimal.valueOf(resultsInPaise[i]).divide(HUNDRED);
        }
        return resultInRupees;
    }

    public static long roundAndConvertToPaise(BigDecimal rupees) {
        return MoneyUtils.roundOffTwo(rupees).multiply(HUNDRED).longValueExact();
    }

    public static BigDecimal roundOffTwo(BigDecimal amount) {
        return amount.setScale(2, 4);
    }

    public static BigDecimal roundOff(BigDecimal amount) {
        return amount.setScale(0, 4);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

