/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import java.util.Collection;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static <T> String toJSON(Collection<T> objects, Class<? extends T> objectClazz, JsonSerializer<T> adapter) {
        return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(objectClazz, adapter).create().toJson(objects);
    }

    public static <T> String toJSON(Collection<T> objects, Class<? extends T> objectClazz, Class<? extends JsonSerializer<T>> adapterClazz) {
        try {
            return JsonUtils.toJSON(objects, objectClazz, adapterClazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object list to json string", e);
        }
    }

    public static <T> String toJSON(T object, JsonSerializer<T> adapter) {
        return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(object.getClass(), adapter).create().toJson(object);
    }

    public static <T> String toJSON(T object, Class<? extends JsonSerializer<T>> adapterClazz) {
        try {
            return JsonUtils.toJSON(object, adapterClazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object to json string", e);
        }
    }

    public static <T> T fromJSON(String json, Class<T> clazz) {
        return (T)new Gson().fromJson(json, clazz);
    }

    public static String toJSON(Object object) {
        return new Gson().toJson(object);
    }
}

