/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStoreUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStoreUtils.class);
    @Autowired
    @Qualifier(value="fileStoreService")
    private FileStoreService fileStoreService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;

    public Path getFileAsPath(String fileStoreId, String moduleName) {
        return this.fileStoreService.fetchAsPath(fileStoreId, moduleName);
    }

    public Optional<FileStoreMapper> getFileStoreMapper(String fileStoreId) {
        return Optional.ofNullable(this.fileStoreMapperRepository.findByFileStoreId(fileStoreId));
    }

    public ResponseEntity<InputStreamResource> fileAsResponseEntity(String fileStoreId, String moduleName, boolean toSave) {
        try {
            Optional<FileStoreMapper> fileStoreMapper = this.getFileStoreMapper(fileStoreId);
            if (fileStoreMapper.isPresent()) {
                Path file = this.getFileAsPath(fileStoreId, moduleName);
                byte[] fileBytes = Files.readAllBytes(file);
                return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)fileStoreMapper.get().getContentType())).cacheControl(CacheControl.noCache())).contentLength((long)fileBytes.length).header("content-disposition", new String[]{String.format(toSave ? "attachment;filename=\"%s\"" : "inline;filename=\"%s\"", fileStoreMapper.get().getFileName())})).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(fileBytes)));
            }
            return ResponseEntity.notFound().build();
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while creating response entity from file mapper", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
    }

    public void writeToHttpResponseStream(String fileStoreId, String moduleName, HttpServletResponse response) {
        try {
            FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(fileStoreId);
            if (fileStoreMapper != null) {
                File file = this.fileStoreService.fetch(fileStoreMapper, moduleName);
                response.setHeader("content-disposition", String.format("inline;filename=\"%s\"", fileStoreMapper.getFileName()));
                response.setContentType(fileStoreMapper.getContentType());
                ServletOutputStream out = response.getOutputStream();
                IOUtils.write((byte[])FileUtils.readFileToByteArray((File)file), (OutputStream)out);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while writing file to response stream", (Throwable)e);
        }
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files, String moduleName) {
        return this.addToFileStore(files, moduleName, false);
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files, String moduleName, boolean compressImage) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.stream(files).filter(file -> !file.isEmpty()).map(file -> {
                try {
                    if (compressImage && file.getContentType().contains("image")) {
                        return this.fileStoreService.store(ImageUtils.compressImage(file), file.getOriginalFilename(), "image/jpeg", moduleName);
                    }
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), moduleName);
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("err.input.stream", e);
                }
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public void copyFileToPath(Path newFilePath, String fileStoreId, String moduleName) throws IOException {
        Optional<FileStoreMapper> fileStoreMapper = this.getFileStoreMapper(fileStoreId);
        if (fileStoreMapper.isPresent()) {
            File file = this.fileStoreService.fetch(fileStoreMapper.get(), moduleName);
            Files.copy(file.toPath(), newFilePath, new CopyOption[0]);
        }
    }

    public byte[] fileAsByteArray(String fileStoreId, String moduleName) {
        try {
            Optional<FileStoreMapper> fileStoreMapper = this.getFileStoreMapper(fileStoreId);
            if (fileStoreMapper.isPresent()) {
                Path file = this.getFileAsPath(fileStoreId, moduleName);
                return Files.readAllBytes(file);
            }
            return new byte[0];
        }
        catch (IOException ioe) {
            LOGGER.error("Error occurred while converting file to byte array", (Throwable)ioe);
            return new byte[0];
        }
    }
}

