/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils.captcha;

import com.octo.captcha.Captcha;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultCaptchaStore
implements CaptchaStore {
    private static final String CAPTCHA_KEY = "captcha_key";
    @Autowired
    private RedisTemplate redisTemplate;
    private BoundHashOperations<String, String, CaptchaAndLocale> captchaStore;

    public boolean hasCaptcha(String key) {
        return this.captchaStore.hasKey((Object)key);
    }

    public void storeCaptcha(String key, Captcha captcha) {
        this.captchaStore.put((Object)key, (Object)new CaptchaAndLocale(captcha));
    }

    public void storeCaptcha(String key, Captcha captcha, Locale locale) {
        this.captchaStore.put((Object)key, (Object)new CaptchaAndLocale(captcha, locale));
    }

    public boolean removeCaptcha(String key) {
        if (this.captchaStore.hasKey((Object)key).booleanValue()) {
            this.captchaStore.delete(new Object[]{key});
            return true;
        }
        return false;
    }

    public Captcha getCaptcha(String key) {
        CaptchaAndLocale captchaAndLocale = (CaptchaAndLocale)this.captchaStore.get((Object)key);
        return captchaAndLocale != null ? captchaAndLocale.getCaptcha() : null;
    }

    public Locale getLocale(String key) {
        CaptchaAndLocale captchaAndLocale = (CaptchaAndLocale)this.captchaStore.get((Object)key);
        return captchaAndLocale != null ? captchaAndLocale.getLocale() : null;
    }

    public int getSize() {
        return this.captchaStore.size().intValue();
    }

    public Collection getKeys() {
        return this.captchaStore.keys();
    }

    public void empty() {
        this.redisTemplate.delete((Object)CAPTCHA_KEY);
    }

    public void initAndStart() {
        this.captchaStore = this.redisTemplate.boundHashOps((Object)CAPTCHA_KEY);
    }

    public void cleanAndShutdown() {
        this.redisTemplate.delete((Object)CAPTCHA_KEY);
    }
}

