/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils.captcha;

import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.egov.infra.security.utils.captcha.DefaultCaptchaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CaptchaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CaptchaUtils.class);
    @Value(value="${captcha.verification.url}")
    private String captchaVerificationUrl;
    @Value(value="#{'${captcha.strength}'.equals('high')}")
    private boolean highlySecure;
    @Autowired
    private DefaultCaptchaService captchaService;

    public boolean captchaIsValid(HttpServletRequest request) {
        try {
            if (this.highlySecure) {
                HttpPost post = new HttpPost(this.captchaVerificationUrl);
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair("secret", (String)request.getSession().getAttribute("siteSecret")));
                urlParameters.add(new BasicNameValuePair("response", request.getParameter("g-recaptcha-response")));
                urlParameters.add(new BasicNameValuePair("remoteip", request.getRemoteAddr()));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
                String responseJson = IOUtils.toString((InputStream)HttpClientBuilder.create().build().execute((HttpUriRequest)post).getEntity().getContent(), (Charset)Charset.defaultCharset());
                return Boolean.valueOf(((HashMap)new GsonBuilder().create().fromJson(responseJson, HashMap.class)).get("success").toString());
            }
            String captchaId = request.getParameter("j_captcha_key");
            String response = request.getParameter("j_captcha_response");
            return this.captchaService.validateResponseForID(captchaId, response);
        }
        catch (Exception e) {
            LOG.error("Recaptcha verification failed", (Throwable)e);
            return false;
        }
    }
}

