/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils.captcha;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.security.utils.captcha.DefaultCaptchaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="jcaptcha")
public class CaptchaServlet
implements HttpRequestHandler {
    @Autowired
    private DefaultCaptchaService defaultCaptchaService;

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try (ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();){
            String captchaId = request.getParameter("key");
            BufferedImage challenge = this.defaultCaptchaService.getImageChallengeForID(captchaId, response.getLocale());
            ImageIO.write((RenderedImage)challenge, "jpg", jpegOutputStream);
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            ServletOutputStream responseStream = response.getOutputStream();
            responseStream.write(jpegOutputStream.toByteArray());
            responseStream.flush();
            responseStream.close();
        }
        catch (IOException | RuntimeException e) {
            response.sendError(404);
            return;
        }
    }
}

