/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils;

import java.util.Optional;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.security.authentication.userdetail.CurrentUser;
import org.egov.infra.persistence.entity.enums.UserType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SecurityUtils {
    @Autowired
    private UserService userService;

    public static boolean userAnonymouslyAuthenticated(Optional<Authentication> authentication) {
        return authentication.isPresent() && authentication.get().getPrincipal() instanceof String;
    }

    public static boolean userAnonymouslyAuthenticated() {
        Optional<Authentication> authentication = SecurityUtils.getCurrentAuthentication();
        return SecurityUtils.userAnonymouslyAuthenticated(authentication);
    }

    public static Optional<Authentication> getCurrentAuthentication() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication());
    }

    public User getCurrentUser() {
        Optional<Authentication> authentication = SecurityUtils.getCurrentAuthentication();
        return !authentication.isPresent() || SecurityUtils.userAnonymouslyAuthenticated(authentication) ? this.userService.getUserByUsername("anonymous") : this.userService.getUserById(((CurrentUser)authentication.get().getPrincipal()).getUserId());
    }

    public UserType currentUserType() {
        Optional<Authentication> authentication = SecurityUtils.getCurrentAuthentication();
        return authentication.isPresent() && !SecurityUtils.userAnonymouslyAuthenticated(authentication) ? ((CurrentUser)authentication.get().getPrincipal()).getUserType() : UserType.SYSTEM;
    }

    public boolean currentUserIsCitizen() {
        return this.currentUserType().equals((Object)UserType.CITIZEN);
    }

    public boolean currentUserIsEmployee() {
        return this.currentUserType().equals((Object)UserType.EMPLOYEE);
    }
}

