/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import org.apache.commons.lang.RandomStringUtils;
import org.egov.infra.config.core.LocalizationSettings;
import org.egov.infra.exception.ApplicationRuntimeException;

public final class SecureCodeUtils {
    private static final int DEFAULT_WIDTH = 125;
    private static final int DEFAULT_HEIGHT = 125;

    private SecureCodeUtils() {
    }

    public static File generateQRCode(String content) {
        return SecureCodeUtils.generateQRCode(content, 125, 125);
    }

    public static File generateQRCode(String content, int qrImgWidth, int qrImgHeight) {
        return SecureCodeUtils.generateSecureCode(content, BarcodeFormat.QR_CODE, qrImgWidth, qrImgHeight);
    }

    public static File generatePDF417Code(String content) {
        return SecureCodeUtils.generatePDF417Code(content, 125, 125);
    }

    public static File generatePDF417Code(String content, int imgWidth, int imgHeight) {
        return SecureCodeUtils.generateSecureCode(content, BarcodeFormat.PDF_417, imgWidth, imgHeight);
    }

    public static File generateSecureCode(String content, BarcodeFormat format, int imgWidth, int imgHeight) {
        try {
            EnumMap<EncodeHintType, Comparable<Charset>> hints = new EnumMap<EncodeHintType, Comparable<Charset>>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, LocalizationSettings.encoding());
            hints.put(EncodeHintType.MARGIN, Integer.valueOf(1));
            BitMatrix secureCodeMatrix = new MultiFormatWriter().encode(content, format, imgWidth, imgHeight, hints);
            Path secureCodePath = Files.createTempFile(RandomStringUtils.randomAlphabetic((int)5), ".png", new FileAttribute[0]);
            MatrixToImageWriter.writeToPath((BitMatrix)secureCodeMatrix, (String)"png", (Path)secureCodePath);
            return secureCodePath.toFile();
        }
        catch (WriterException | IOException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Secure Code", e);
        }
    }
}

