/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.audit.repository.specs;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.security.audit.contract.LoginAuditReportRequest;
import org.egov.infra.security.audit.entity.LoginAudit;
import org.egov.infra.utils.DateUtils;
import org.springframework.data.jpa.domain.Specification;

public class LoginAuditSpec {
    private LoginAuditSpec() {
    }

    public static final Specification<LoginAudit> loginAuditSearchSpec(LoginAuditReportRequest loginAuditReportRequest) {
        return (root, query, builder) -> {
            Predicate predicate = builder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)loginAuditReportRequest.getUserName())) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("user").get("name"), (Object)loginAuditReportRequest.getUserName()));
            }
            if (loginAuditReportRequest.getUserType() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("user").get("type"), (Object)loginAuditReportRequest.getUserType()));
            }
            if (StringUtils.isNotBlank((CharSequence)loginAuditReportRequest.getIpAddress())) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("ipAddress"), (Object)loginAuditReportRequest.getIpAddress()));
            }
            if (loginAuditReportRequest.getLoginFrom() != null) {
                predicate.getExpressions().add(builder.greaterThanOrEqualTo((Expression)root.get("loginTime"), (Comparable)loginAuditReportRequest.getLoginFrom()));
            }
            if (loginAuditReportRequest.getLoginTo() != null) {
                predicate.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get("loginTime"), (Comparable)DateUtils.endOfDay(loginAuditReportRequest.getLoginTo())));
            }
            return predicate;
        };
    }
}

