/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.audit.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.egov.infra.admin.master.entity.User;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_loginaudit")
@SequenceGenerator(name="SEQ_EG_LOGINAUDIT", sequenceName="SEQ_EG_LOGINAUDIT", allocationSize=1)
public class LoginAudit
implements Serializable {
    protected static final String SEQ_LOGINAUDIT = "SEQ_EG_LOGINAUDIT";
    private static final long serialVersionUID = 3860739186574812587L;
    @Id
    @GeneratedValue(generator="SEQ_EG_LOGINAUDIT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="userid")
    private User user;
    @SafeHtml
    @NotBlank
    private String ipAddress;
    @SafeHtml
    @NotBlank
    private String userAgent;
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy hh:mm a", timezone="IST")
    private Date loginTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy hh:mm a", timezone="IST")
    private Date logoutTime;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Date getLoginTime() {
        return this.loginTime;
    }

    public void setLoginTime(Date loginTime) {
        this.loginTime = loginTime;
    }

    public Date getLogoutTime() {
        return this.logoutTime;
    }

    public void setLogoutTime(Date logoutTime) {
        this.logoutTime = logoutTime;
    }
}

