/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.script.service;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.egov.infra.cache.impl.LRUCache;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.repository.ScriptRepository;
import org.egov.infra.script.service.ScriptEngineProvider;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class ScriptService {
    private static LRUCache<String, Script> scriptCache;
    private static final Logger LOG;
    @Autowired
    private ScriptRepository scriptRepository;
    @Autowired
    private ScriptEngineProvider scriptEngineProvider;

    public Script getByName(String name) {
        return this.scriptRepository.findByName(name);
    }

    public Script findByNameAndPeriod(String name, Date period) {
        return this.scriptRepository.findByNameAndPeriod(name, period);
    }

    public ScriptService() {
        if (scriptCache == null) {
            scriptCache = new LRUCache(10, 50);
        }
    }

    public static ScriptContext createContext(Object ... args) {
        SimpleScriptContext context = new SimpleScriptContext();
        if (args.length % 2 != 0) {
            throw new ApplicationRuntimeException("Number of arguments must be even");
        }
        for (int i = 0; i < args.length; i += 2) {
            context.setAttribute((String)args[i], args[i + 1], 100);
        }
        return context;
    }

    public void loadFunctionsFromScript(String scriptName) {
        Script script = this.getScript(scriptName, DateUtils.today());
        ScriptEngine engine = this.scriptEngineProvider.getScriptEngine(script.getType());
        this.executeScript(script, engine, engine.getContext());
    }

    private void setupContextAttributes(ScriptEngine engine, ScriptContext context) {
        context.setAttribute("scriptService", this, 100);
        context.setAttribute("scriptEngine", engine, 100);
        context.setAttribute("scriptContext", context, 100);
    }

    private Object executeScript(Script script, ScriptEngine engine, ScriptContext context) {
        if (context == null) {
            String errMsg = "ScriptContext not passed to executeScript method!";
            LOG.error("ScriptContext not passed to executeScript method!");
            throw new ApplicationRuntimeException("ScriptContext not passed to executeScript method!");
        }
        Object evalResult = null;
        this.setupContextAttributes(engine, context);
        try {
            CompiledScript compiledScript = script.getCompiledScript();
            evalResult = engine instanceof Compilable && compiledScript != null ? compiledScript.eval(context) : engine.eval(script.getScript(), context);
            this.handleErrorsIfAny(context.getAttribute("validationErrors"));
            Object result = context.getAttribute("result");
            return evalResult == null ? result : evalResult;
        }
        catch (ScriptException e) {
            LOG.error("script error for " + script.getType() + ":" + script.getName() + ":" + script.getScript(), (Throwable)e);
            throw new ApplicationRuntimeException("script.error", e);
        }
        catch (ValidationException e) {
            if (e.getErrors() != null && !e.getErrors().isEmpty()) {
                LOG.error(e.getErrors().get(0).getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception  for " + script.getType() + ":" + script.getName() + ":" + script.getScript(), (Throwable)e);
            throw new ApplicationRuntimeException("script.error", e);
        }
    }

    public Object executeFunctionNoArgs(ScriptEngine engine, String functionName) {
        return this.executeFunction(engine, functionName, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeFunction(ScriptEngine engine, String functionName, Object ... args) {
        Object evalResult = null;
        if (engine instanceof Invocable) {
            try {
                evalResult = ((Invocable)((Object)engine)).invokeFunction(functionName, args);
                if (evalResult != null) return evalResult;
                return engine.get("result");
            }
            catch (Exception e) {
                String errMsg = "Exception while invoking function [" + functionName + "]";
                LOG.error(errMsg, (Throwable)e);
                throw new ApplicationRuntimeException(errMsg, e);
            }
        }
        String errMsg = "Script engine [" + engine + "] does not support method execution!";
        LOG.error(errMsg);
        throw new ApplicationRuntimeException(errMsg);
    }

    private CompiledScript compileScriptIfRequired(Script script) {
        CompiledScript compiledScript = script.getCompiledScript();
        if (compiledScript != null) {
            return compiledScript;
        }
        ScriptEngine engine = this.scriptEngineProvider.getScriptEngine(script.getType());
        if (engine instanceof Compilable) {
            try {
                compiledScript = ((Compilable)((Object)engine)).compile(script.getScript());
                script.setCompiledScript(compiledScript);
            }
            catch (ScriptException e) {
                String errMsg = "Could not compile script " + script.getType() + ":" + script.getName() + ":" + script.getScript();
                LOG.error(errMsg, (Throwable)e);
                throw new ApplicationRuntimeException(errMsg, e);
            }
        }
        return compiledScript;
    }

    private Script getScript(String scriptName, Date asOnDate) {
        Script script;
        Date currentDate = new Date();
        if (asOnDate != null) {
            currentDate = asOnDate;
        }
        if ((script = (Script)scriptCache.get(scriptName)) != null && new DateTime((Object)script.getPeriod().getEndDate()).isAfter((ReadableInstant)new DateTime(asOnDate.getTime()))) {
            return script;
        }
        script = this.scriptRepository.findByNameAndPeriod(scriptName, currentDate);
        if (script == null) {
            throw new ApplicationRuntimeException("Script [" + scriptName + "] not found!");
        }
        this.compileScriptIfRequired(script);
        scriptCache.put(scriptName, script);
        return script;
    }

    public Object executeScript(Script script, ScriptContext context) {
        ScriptEngine engine = this.scriptEngineProvider.getScriptEngine(script.getType());
        return this.executeScript(script, engine, context);
    }

    public Object executeScript(String scriptName, ScriptContext context) {
        return this.executeScript(this.getScript(scriptName, DateUtils.today()), context);
    }

    public Object executeScript(String scriptName, ScriptContext context, Date asOnDate) {
        return this.executeScript(this.getScript(scriptName, asOnDate), context);
    }

    private void handleErrorsIfAny(Object errors) {
        if (errors != null) {
            List<ValidationError> validationErrors = null;
            validationErrors = errors instanceof List ? (List<ValidationError>)errors : (errors instanceof Map ? this.toErrors((Map)errors) : Arrays.asList(new ValidationError(errors.toString(), errors.toString())));
            throw new ValidationException(validationErrors);
        }
    }

    private List<ValidationError> toErrors(Map errors) {
        LinkedList<ValidationError> validationErrors = new LinkedList<ValidationError>();
        Set errorEntries = errors.entrySet();
        for (Map.Entry entry : errorEntries) {
            validationErrors.add(new ValidationError(entry.getKey().toString(), entry.getValue().toString()));
        }
        return validationErrors;
    }

    public void clearScriptCache() {
        scriptCache.clear();
    }

    static {
        LOG = LoggerFactory.getLogger(ScriptService.class);
    }
}

