/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.script.service;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.egov.infra.cache.impl.LRUCache;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.python.core.Options;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineProvider {
    private static LRUCache<String, ScriptEngine> SCRIPT_ENGINE_CACHE;

    public ScriptEngineProvider() {
        if (SCRIPT_ENGINE_CACHE == null) {
            SCRIPT_ENGINE_CACHE = new LRUCache(2, 10);
        }
    }

    public ScriptEngine getScriptEngine(String scriptType) {
        ScriptEngine engine = (ScriptEngine)SCRIPT_ENGINE_CACHE.get(scriptType);
        if (engine == null) {
            ScriptEngineManager m = new ScriptEngineManager();
            if ("python".equals(scriptType)) {
                Options.importSite = false;
            }
            if ((engine = m.getEngineByName(scriptType)) == null) {
                throw new ApplicationRuntimeException("Could not get script engine for [" + scriptType + "]");
            }
            SCRIPT_ENGINE_CACHE.put(scriptType, engine);
        }
        return engine;
    }
}

