/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.scheduler.quartz;

import java.util.Map;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.quartz.JobDataMap;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class QuartzJobAwareBeanFactory
extends SpringBeanJobFactory
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzJobAwareBeanFactory.class);
    private static final String SCHEDULER_NAME = "%s-scheduler";
    private static final String MODULE_NAME_KEY = "moduleName";
    private static final String JOB_BEAN_NAME_KEY = "jobBeanName";
    private String[] ignoredUnknownProperties;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setIgnoredUnknownProperties(String[] ignoredUnknownProperties) {
        super.setIgnoredUnknownProperties(ignoredUnknownProperties);
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) {
        try {
            JobDataMap jobDataMap = bundle.getJobDetail().getJobDataMap();
            SchedulerContext schedulerContext = SchedulerRepository.getInstance().lookup(String.format(SCHEDULER_NAME, jobDataMap.getString(MODULE_NAME_KEY))).getContext();
            Object job = this.applicationContext.getBean(jobDataMap.getString(JOB_BEAN_NAME_KEY), bundle.getJobDetail().getJobClass());
            BeanWrapperImpl bw = new BeanWrapperImpl(job);
            if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
                MutablePropertyValues pvs = new MutablePropertyValues();
                if (schedulerContext != null) {
                    pvs.addPropertyValues((Map)schedulerContext);
                }
                pvs.addPropertyValues((Map)jobDataMap);
                pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
                if (this.ignoredUnknownProperties != null) {
                    for (String property : this.ignoredUnknownProperties) {
                        if (!pvs.contains(property) || bw.isWritableProperty(property)) continue;
                        pvs.removePropertyValue(property);
                    }
                    bw.setPropertyValues((PropertyValues)pvs);
                } else {
                    bw.setPropertyValues((PropertyValues)pvs, true);
                }
            }
            return bw.getWrappedInstance();
        }
        catch (SchedulerException e) {
            LOGGER.error("Error occurred while initializing Scheduler Job Beans", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred while initializing Scheduler", e);
        }
    }
}

