/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.viewer;

import java.util.UUID;
import org.egov.infra.cache.impl.ApplicationCacheManager;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportViewerUtil {
    @Autowired
    private ApplicationCacheManager applicationCacheManager;

    public static String getContentType(ReportFormat fileFormat) {
        return ReportUtil.contentType(fileFormat);
    }

    public static String getContentDisposition(ReportFormat fileFormat) {
        return "inline; filename=report." + fileFormat.toString();
    }

    public String addReportToTempCache(ReportOutput reportOutput) {
        String reportId = UUID.randomUUID().toString();
        this.applicationCacheManager.put(reportId, reportOutput);
        return reportId;
    }

    public ReportOutput getReportOutputFormCache(String reportOutputCacheKey) {
        return this.applicationCacheManager.get(reportOutputCacheKey, ReportOutput.class);
    }

    public void removeReportOutputFromCache(String reportOutputCacheKey) {
        this.applicationCacheManager.remove(reportOutputCacheKey);
    }
}

