/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.viewer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="reportViewer")
public class ReportViewer
implements HttpRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportViewer.class);
    private static final String REPORT_ERROR_CONTENT = "<html><body><b>ERROR: %s!</b></body></html>";
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reportId = request.getParameter("reportId");
        try {
            ReportOutput reportOutput = this.reportViewerUtil.getReportOutputFormCache(reportId);
            if (reportOutput == null) {
                this.renderHtml(response, "Report output not available");
                return;
            }
            ReportFormat reportFormat = reportOutput.getReportFormat();
            if (reportFormat == null) {
                this.renderHtml(response, "Report format not available");
                return;
            }
            byte[] reportData = reportOutput.getReportOutputData();
            if (reportData == null) {
                this.renderHtml(response, "Report data not available");
                return;
            }
            this.renderReport(response, reportData, reportFormat);
        }
        catch (Exception e) {
            LOGGER.error("Invalid report id [{}]", (Object)reportId, (Object)e);
            this.renderHtml(response, "Report can not be rendered");
        }
        finally {
            this.reportViewerUtil.removeReportOutputFromCache(reportId);
        }
    }

    private void renderHtml(HttpServletResponse resp, String htmContent) {
        this.renderReport(resp, String.format(REPORT_ERROR_CONTENT, htmContent).getBytes(), ReportFormat.HTM);
    }

    private void renderReport(HttpServletResponse resp, byte[] reportData, ReportFormat reportFormat) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
            resp.setHeader("content-disposition", ReportViewerUtil.getContentDisposition(reportFormat));
            resp.setContentType(ReportViewerUtil.getContentType(reportFormat));
            resp.setContentLength(reportData.length);
            outputStream.write(reportData);
        }
        catch (Exception e) {
            LOGGER.error("Exception in rendering report with format [{}]!", (Throwable)e);
            throw new ApplicationRuntimeException("Error occurred in report viewer", e);
        }
    }
}

