/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.EnumMap;
import java.util.Properties;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public final class ReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtil.class);
    private static final EnumMap<ReportFormat, String> CONTENT_TYPES = new EnumMap(ReportFormat.class);

    private ReportUtil() {
    }

    public static String contentType(ReportFormat reportFormat) {
        return CONTENT_TYPES.get((Object)reportFormat);
    }

    public static InputStream getImageAsStream(String imageName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("/egi/resources/global/images/" + imageName);
    }

    public static String getCityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public static InputStream getTemplateAsStream(String templateName) {
        InputStream fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("/reports/templates/%s/%s", ApplicationThreadLocals.getTenantID(), templateName));
        if (fileInputStream == null) {
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("/reports/templates/%s/%s", "common", templateName));
        }
        if (fileInputStream == null) {
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("/reports/templates/%s", templateName));
        }
        if (fileInputStream == null) {
            String errMsg = "File [" + templateName + "] could not be loaded from CLASSPATH!";
            LOGGER.error(errMsg);
            throw new ApplicationRuntimeException(errMsg);
        }
        return fileInputStream;
    }

    public static Properties loadReportConfig() {
        Properties reportProps = null;
        try {
            InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/config/reports.properties");
            if (configStream != null) {
                reportProps = new Properties();
                reportProps.load(configStream);
            }
            return reportProps;
        }
        catch (IOException e) {
            LOGGER.warn("Exception while loading report configuration file [{}]", (Object)"/config/reports.properties", (Object)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Object fetchFromDBSql(Connection connection, String sqlQuery) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Date getDate(int year, int month, int date) {
        return DateUtils.getDate(year, month, date);
    }

    public static Date today() {
        return DateUtils.today();
    }

    public static Date now() {
        return DateUtils.now();
    }

    public static Date tomorrow() {
        return DateUtils.tomorrow();
    }

    public static Date add(Date inputDate, int addType, int addAmount) {
        return DateUtils.add(inputDate, addType, addAmount);
    }

    public static String amountInWords(BigDecimal amount) {
        return NumberUtil.amountInWords(amount);
    }

    public static String formatNumber(BigDecimal number, int fractionDigits, boolean useGrouping) {
        return NumberUtil.formatNumber(number, fractionDigits, useGrouping);
    }

    public static String logoBasePath() {
        return String.format("%s/egi/downloadfile/logo", ApplicationThreadLocals.getDomainURL());
    }

    public static String cancelledWatermarkAbsolutePath() {
        return String.format("%s/egi/resources/global/images/cancelled_watermark.png", ApplicationThreadLocals.getDomainURL());
    }

    public static ResponseEntity<InputStreamResource> reportAsResponseEntity(ReportOutput reportOutput) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.valueOf((String)ReportUtil.contentType(reportOutput.getReportFormat()))).cacheControl(CacheControl.noCache())).contentLength((long)reportOutput.getReportOutputData().length).header("content-disposition", new String[]{reportOutput.reportDisposition()})).body((Object)new InputStreamResource(reportOutput.asInputStream()));
    }

    public static URL logoAsStream() throws MalformedURLException {
        return new URL(ReportUtil.logoBasePath());
    }

    static {
        CONTENT_TYPES.put(ReportFormat.PDF, "application/pdf");
        CONTENT_TYPES.put(ReportFormat.XLS, "application/vnd.ms-excel");
        CONTENT_TYPES.put(ReportFormat.RTF, "application/rtf");
        CONTENT_TYPES.put(ReportFormat.HTM, "text/html");
        CONTENT_TYPES.put(ReportFormat.TXT, "text/plain");
        CONTENT_TYPES.put(ReportFormat.CSV, "text/plain");
    }
}

