/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportRequest;

public class ReportOutput
implements Serializable {
    private static final long serialVersionUID = -2559611205589631905L;
    private byte[] reportOutputData;
    private ReportFormat reportFormat;
    private String reportName;
    private ReportDisposition reportDisposition = ReportDisposition.INLINE;

    public ReportOutput() {
    }

    public ReportOutput(byte[] reportOutputData, ReportRequest reportInput) {
        this.reportOutputData = reportOutputData;
        this.reportFormat = reportInput.getReportFormat();
    }

    public byte[] getReportOutputData() {
        return this.reportOutputData;
    }

    public void setReportOutputData(byte[] reportOutputData) {
        this.reportOutputData = reportOutputData;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setReportDisposition(ReportDisposition reportDisposition) {
        this.reportDisposition = reportDisposition;
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.reportOutputData);
    }

    public String reportDisposition() {
        return String.format(this.reportDisposition == ReportDisposition.INLINE ? "inline;filename=\"%s\"" : "attachment;filename=\"%s\"", this.reportName) + "." + (Object)((Object)this.reportFormat);
    }
}

