/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.validator.annotation.UniqueDateOverlap;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class UniqueDateOverlapValidator
implements ConstraintValidator<UniqueDateOverlap, Object> {
    private UniqueDateOverlap uniqueDateOverlap;
    @PersistenceContext
    private EntityManager entityManager;

    public void initialize(UniqueDateOverlap uniqueDateOverlap) {
        this.uniqueDateOverlap = uniqueDateOverlap;
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        try {
            boolean isValid = this.checkUnique(object);
            if (!isValid) {
                context.buildConstraintViolationWithTemplate(this.uniqueDateOverlap.message()).addPropertyNode(this.uniqueDateOverlap.fromField()).addConstraintViolation();
            }
            return isValid;
        }
        catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException("Error while validating unique key with date overlapping", e);
        }
    }

    private boolean checkUnique(Object object) throws IllegalAccessException {
        Number id = (Number)FieldUtils.readField((Object)object, (String)this.uniqueDateOverlap.id(), (boolean)true);
        Criteria uniqueDateOverlapChecker = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(object.getClass()).setReadOnly(true);
        Conjunction uniqueCheck = Restrictions.conjunction();
        for (String fieldName : this.uniqueDateOverlap.uniqueFields()) {
            Object fieldValue = FieldUtils.readField((Object)object, (String)fieldName, (boolean)true);
            if (fieldValue instanceof String) {
                uniqueCheck.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue).ignoreCase());
                continue;
            }
            uniqueCheck.add((Criterion)Restrictions.eq((String)fieldName, (Object)fieldValue));
        }
        Date fromDate = DateUtils.startOfDay((Date)FieldUtils.readField((Object)object, (String)this.uniqueDateOverlap.fromField(), (boolean)true));
        Date toDate = DateUtils.endOfDay((Date)FieldUtils.readField((Object)object, (String)this.uniqueDateOverlap.toField(), (boolean)true));
        Conjunction checkFromDate = Restrictions.conjunction();
        checkFromDate.add((Criterion)Restrictions.le((String)this.uniqueDateOverlap.fromField(), (Object)fromDate));
        checkFromDate.add((Criterion)Restrictions.ge((String)this.uniqueDateOverlap.toField(), (Object)fromDate));
        Conjunction checkToDate = Restrictions.conjunction();
        checkToDate.add((Criterion)Restrictions.le((String)this.uniqueDateOverlap.fromField(), (Object)toDate));
        checkToDate.add((Criterion)Restrictions.ge((String)this.uniqueDateOverlap.toField(), (Object)toDate));
        Conjunction checkFromAndToDate = Restrictions.conjunction();
        checkFromAndToDate.add((Criterion)Restrictions.ge((String)this.uniqueDateOverlap.fromField(), (Object)fromDate));
        checkFromAndToDate.add((Criterion)Restrictions.le((String)this.uniqueDateOverlap.toField(), (Object)toDate));
        Disjunction dateRangeChecker = Restrictions.disjunction();
        dateRangeChecker.add((Criterion)checkFromDate).add((Criterion)checkToDate).add((Criterion)checkFromAndToDate);
        uniqueCheck.add((Criterion)dateRangeChecker);
        if (id != null) {
            uniqueCheck.add((Criterion)Restrictions.ne((String)this.uniqueDateOverlap.id(), (Object)id));
        }
        return uniqueDateOverlapChecker.add((Criterion)uniqueCheck).setProjection((Projection)Projections.id()).setMaxResults(1).uniqueResult() == null;
    }
}

