/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.egov.infra.persistence.validator.annotation.GreaterThan;

public class GreaterThanValidator
implements ConstraintValidator<GreaterThan, Object> {
    private GreaterThan greaterThan;

    public void initialize(GreaterThan greaterThan) {
        this.greaterThan = greaterThan;
    }

    public boolean isValid(Object value, ConstraintValidatorContext arg1) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            BigDecimal dv = new BigDecimal((String)value);
            return dv.compareTo(BigDecimal.valueOf(this.greaterThan.value())) > 0;
        }
        if (value instanceof Double || value instanceof Float) {
            double dv = ((Number)value).doubleValue();
            return dv > (double)this.greaterThan.value();
        }
        if (value instanceof Number) {
            long lv = ((Number)value).longValue();
            return lv > this.greaterThan.value();
        }
        return false;
    }
}

