/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.utils;

import javax.persistence.EntityManager;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;

public final class PersistenceUtils {
    private PersistenceUtils() {
    }

    public static <T> T unproxy(T proxy) {
        if (proxy == null) {
            return null;
        }
        Hibernate.initialize(proxy);
        if (proxy instanceof HibernateProxy) {
            return (T)((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation();
        }
        return proxy;
    }

    public static void flushBatchUpdate(EntityManager entityManager, int batchUpdateCount, int batchSize) {
        if (batchUpdateCount % batchSize == 0) {
            ((Session)entityManager.unwrap(Session.class)).flush();
            ((Session)entityManager.unwrap(Session.class)).clear();
        }
    }
}

