/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.notification.service;

import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    @Autowired
    private JavaMailSenderImpl mailSender;

    public void sendEmail(String toEmail, String subject, String mailBody) {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(toEmail);
        mailMessage.setSubject(subject);
        mailMessage.setText(mailBody);
        this.mailSender.send(mailMessage);
    }

    public void sendEmail(String toEmail, String subject, String mailBody, String fileType, String fileName, byte[] attachment) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(message, true);
            mimeMessageHelper.setTo(toEmail);
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setText(mailBody);
            ByteArrayDataSource source = new ByteArrayDataSource(attachment, fileType);
            mimeMessageHelper.addAttachment(fileName, (DataSource)source);
        }
        catch (IllegalArgumentException | MessagingException e) {
            throw new ApplicationRuntimeException("Error occurred while sending email with attachment", e);
        }
        this.mailSender.send(message);
    }
}

