/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.microservice.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.microservice.contract.CreateUserRequest;
import org.egov.infra.microservice.contract.RequestInfoWrapper;
import org.egov.infra.microservice.contract.Task;
import org.egov.infra.microservice.contract.TaskResponse;
import org.egov.infra.microservice.contract.UserDetailResponse;
import org.egov.infra.microservice.contract.UserRequest;
import org.egov.infra.microservice.models.RequestInfo;
import org.egov.infra.microservice.models.RoleInfo;
import org.egov.infra.microservice.models.UserInfo;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.support.ui.Inbox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MicroserviceUtils {
    private static final Logger LOGGER = Logger.getLogger(MicroserviceUtils.class);
    private static final String CLIENT_ID = "client.id";
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private Environment environment;
    @Autowired
    private RoleService roleService;
    @Value(value="${egov.services.workflow.url}")
    private String workflowServiceUrl;
    @Value(value="${egov.services.user.create.url}")
    private String userServiceUrl;

    public RequestInfo createRequestInfo() {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setApiId("apiId");
        requestInfo.setVer("ver");
        requestInfo.setTs(new Date());
        requestInfo.setUserInfo(this.getUserInfo());
        return requestInfo;
    }

    public UserInfo getUserInfo() {
        User user = this.securityUtils.getCurrentUser();
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        user.getRoles().forEach(authority -> roles.add(new RoleInfo(authority.getName())));
        return new UserInfo(roles, user.getId(), user.getUsername(), user.getName(), user.getEmailId(), user.getMobileNumber(), user.getType().toString(), this.getTanentId());
    }

    public String getTanentId() {
        String clientId = this.environment.getProperty(CLIENT_ID);
        String tenantId = ApplicationThreadLocals.getTenantID();
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clientId).append('.').append(tenantId);
            tenantId = stringBuilder.toString();
        }
        return tenantId;
    }

    public void createUserMicroservice(User user) {
        if (StringUtils.isNotBlank((CharSequence)this.userServiceUrl)) {
            if (user.getRoles().isEmpty() && user.getType().equals((Object)UserType.CITIZEN)) {
                user.addRole(this.roleService.getRoleByName("CITIZEN"));
            }
            CreateUserRequest createUserRequest = new CreateUserRequest();
            UserRequest userRequest = new UserRequest(user, this.getTanentId());
            createUserRequest.setUserRequest(userRequest);
            createUserRequest.setRequestInfo(this.createRequestInfo());
            RestTemplate restTemplate = new RestTemplate();
            try {
                restTemplate.postForObject(this.userServiceUrl, (Object)createUserRequest, UserDetailResponse.class, new Object[0]);
            }
            catch (Exception e) {
                String errMsg = "Exception while creating User in microservice ";
                LOGGER.fatal((Object)"Exception while creating User in microservice ", (Throwable)e);
            }
        }
    }

    public List<Task> getTasks() {
        List<Task> tasks = new ArrayList<Task>();
        if (StringUtils.isNotBlank((CharSequence)this.workflowServiceUrl)) {
            RestTemplate restTemplate = new RestTemplate();
            try {
                RequestInfo createRequestInfo = this.createRequestInfo();
                RequestInfoWrapper requestInfo = new RequestInfoWrapper();
                requestInfo.setRequestInfo(createRequestInfo);
                TaskResponse tresp = (TaskResponse)restTemplate.postForObject(this.workflowServiceUrl, (Object)requestInfo, TaskResponse.class, new Object[0]);
                tasks = tresp.getTasks();
            }
            catch (Exception e) {
                String errMsg = "Exception while getting inbox items from microservice ";
                LOGGER.fatal((Object)"Exception while getting inbox items from microservice ", (Throwable)e);
            }
        }
        return tasks;
    }

    public List<Inbox> getInboxItems() {
        LinkedList<Inbox> inboxItems = new LinkedList<Inbox>();
        if (this.hasWorkflowService()) {
            for (Task t : this.getTasks()) {
                Inbox inboxItem = new Inbox();
                inboxItem.setId(t.getId());
                inboxItem.setCreatedDate(t.getCreatedDate());
                inboxItem.setDate(DateUtils.toDefaultDateTimeFormat(t.getCreatedDate()));
                inboxItem.setSender(t.getSenderName());
                inboxItem.setTask(t.getNatureOfTask());
                inboxItem.setStatus(t.getStatus());
                inboxItem.setDetails(t.getDetails());
                inboxItem.setLink(t.getUrl());
                inboxItem.setSender(t.getSenderName());
                inboxItems.add(inboxItem);
            }
        }
        return inboxItems;
    }

    public boolean hasWorkflowService() {
        return StringUtils.isNotBlank((CharSequence)this.workflowServiceUrl);
    }
}

