/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.microservice.contract;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.microservice.contract.RoleRequest;
import org.egov.infra.persistence.entity.enums.UserType;

public class UserRequest {
    private Long id;
    private String userName;
    private String salutation;
    private String name;
    private String gender;
    private String mobileNumber;
    private String emailId;
    private String altContactNumber;
    private String pan;
    private String aadhaarNumber;
    private String permanentAddress;
    private String permanentCity;
    private String permanentPinCode;
    private String correspondenceAddress;
    private String correspondenceCity;
    private String correspondencePinCode;
    private Boolean active;
    private String locale;
    private UserType type;
    private Boolean accountLocked;
    private String fatherOrHusbandName;
    private String signature;
    private String bloodGroup;
    private String photo;
    private String identificationMark;
    private Long createdBy;
    private String password;
    private String otpReference;
    private Long lastModifiedBy;
    private String tenantId;
    private List<RoleRequest> roles;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss", timezone="IST")
    private Date createdDate;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss", timezone="IST")
    private Date lastModifiedDate;
    @JsonFormat(pattern="MM/dd/YYYY")
    private Date dob;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss", timezone="IST")
    private Date pwdExpiryDate;

    public UserRequest() {
    }

    public UserRequest(User user, String tenantId) {
        this.id = user.getId();
        this.userName = user.getUsername();
        this.salutation = user.getSalutation();
        this.name = user.getName();
        this.gender = user.getGender() != null ? user.getGender().toString() : null;
        this.mobileNumber = user.getMobileNumber();
        this.emailId = user.getEmailId();
        this.altContactNumber = user.getAltContactNumber();
        this.pan = user.getPan();
        this.aadhaarNumber = user.getAadhaarNumber();
        this.active = user.isActive();
        this.dob = user.getDob();
        this.password = user.getPassword();
        this.pwdExpiryDate = user.getPwdExpiryDate().toDate();
        this.locale = user.getLocale();
        this.type = user.getType();
        this.accountLocked = user.isAccountLocked();
        this.createdBy = user.getCreatedBy() == null ? 0L : user.getCreatedBy().getId();
        this.createdDate = user.getCreatedDate();
        this.lastModifiedBy = user.getLastModifiedBy() == null ? 0L : user.getLastModifiedBy().getId();
        this.lastModifiedDate = user.getLastModifiedDate();
        this.tenantId = tenantId;
        this.roles = this.convertRoleEntitiesToContract(user.getRoles());
    }

    private List<RoleRequest> convertRoleEntitiesToContract(Set<Role> domainRoles) {
        if (domainRoles == null) {
            return new ArrayList<RoleRequest>();
        }
        return domainRoles.stream().map(RoleRequest::new).collect(Collectors.toList());
    }

    public Long getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public String getPan() {
        return this.pan;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public String getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getPermanentCity() {
        return this.permanentCity;
    }

    public String getPermanentPinCode() {
        return this.permanentPinCode;
    }

    public String getCorrespondenceAddress() {
        return this.correspondenceAddress;
    }

    public String getCorrespondenceCity() {
        return this.correspondenceCity;
    }

    public String getCorrespondencePinCode() {
        return this.correspondencePinCode;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getLocale() {
        return this.locale;
    }

    public UserType getType() {
        return this.type;
    }

    public Boolean getAccountLocked() {
        return this.accountLocked;
    }

    public String getFatherOrHusbandName() {
        return this.fatherOrHusbandName;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getBloodGroup() {
        return this.bloodGroup;
    }

    public String getPhoto() {
        return this.photo;
    }

    public String getIdentificationMark() {
        return this.identificationMark;
    }

    public Long getCreatedBy() {
        return this.createdBy;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOtpReference() {
        return this.otpReference;
    }

    public Long getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<RoleRequest> getRoles() {
        return this.roles;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Date getDob() {
        return this.dob;
    }

    public Date getPwdExpiryDate() {
        return this.pwdExpiryDate;
    }
}

