/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.filestore.entity;

import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.hibernate.validator.constraints.NotBlank;

@Table(name="eg_filestoremap")
@Entity
@SequenceGenerator(name="SEQ_EG_FILESTOREMAP", sequenceName="SEQ_EG_FILESTOREMAP", allocationSize=1)
public class FileStoreMapper
extends AbstractPersistable<Long> {
    public static final String SEQ_FILESTOREMAPPER = "SEQ_EG_FILESTOREMAP";
    private static final long serialVersionUID = -2997164207274266823L;
    @Id
    @GeneratedValue(generator="SEQ_EG_FILESTOREMAP", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @Column(length=36, unique=true, nullable=false)
    private String fileStoreId;
    @NotBlank
    private String fileName;
    private String contentType;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate = new Date();

    protected FileStoreMapper() {
    }

    public FileStoreMapper(String fileStoreId, String fileName) {
        this.fileStoreId = fileStoreId;
        this.fileName = fileName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getFileStoreId() {
        return this.fileStoreId;
    }

    public void setFileStoreId(String fileStoreId) {
        this.fileStoreId = fileStoreId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStoreMapper)) {
            return false;
        }
        FileStoreMapper that = (FileStoreMapper)o;
        return that.id != null && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

