/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.session;

import org.egov.infra.config.security.authentication.listener.UserSessionDestroyListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.CookieHttpSessionStrategy;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@EnableRedisHttpSession
public class RedisHttpSessionConfiguration {
    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("SESSIONID");
        serializer.setCookiePath("/");
        return serializer;
    }

    @Bean
    public CookieHttpSessionStrategy cookieHttpSessionStrategy(CookieSerializer cookieSerializer) {
        CookieHttpSessionStrategy cookieHttpSession = new CookieHttpSessionStrategy();
        cookieHttpSession.setCookieSerializer(cookieSerializer);
        return cookieHttpSession;
    }

    @Bean
    public SpringSessionBackedSessionRegistry springSessionBackedSessionRegistry(FindByIndexNameSessionRepository sessionRepository) {
        return new SpringSessionBackedSessionRegistry(sessionRepository);
    }

    @Bean
    public UserSessionDestroyListener httpSessionEventPublisher() {
        return new UserSessionDestroyListener();
    }
}

