/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.security.authentication.provider;

import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.security.audit.entity.LoginAttempt;
import org.egov.infra.security.audit.service.LoginAttemptService;
import org.egov.infra.security.utils.captcha.CaptchaUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApplicationAuthenticationProvider
extends DaoAuthenticationProvider {
    private static final String BAD_CRED_MSG_KEY = "AbstractUserDetailsAuthenticationProvider.badCredentials";
    private static final String BAD_CRED_DEFAULT_MSG = "Bad credentials";
    private static final String ACCOUNT_LOCKED_MSG_KEY = "AbstractUserDetailsAuthenticationProvider.locked";
    private static final String ACCOUNT_LOCKED_DEFAULT_MSG = "User account is locked";
    private static final String TOO_MANY_ATTEMPTS_MSG_FORMAT = "Too many attempts [%d]";
    private static final String INVALID_CAPTCHA_MSG_FORMAT = "%s - Recaptcha Invalid";
    private static final String CAPTCHA_FIELD = "j_captcha_response";
    private static final String RECAPTCHA_FIELD = "g-recaptcha-response";
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private LoginAttemptService loginAttemptService;
    @Autowired
    private CaptchaUtils recaptchaUtils;

    public Authentication authenticate(Authentication authentication) {
        try {
            return super.authenticate(authentication);
        }
        catch (BadCredentialsException ex) {
            this.lockAccount(authentication);
            throw ex;
        }
        catch (LockedException le) {
            return this.unlockAccount(authentication, le);
        }
    }

    private Authentication unlockAccount(Authentication authentication, LockedException le) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(RECAPTCHA_FIELD)) || StringUtils.isNotBlank((CharSequence)request.getParameter(CAPTCHA_FIELD))) {
            if (this.recaptchaUtils.captchaIsValid(request)) {
                this.loginAttemptService.resetFailedAttempt(authentication.getName());
                return super.authenticate(authentication);
            }
            throw new LockedException(String.format(INVALID_CAPTCHA_MSG_FORMAT, le.getMessage()));
        }
        throw le;
    }

    private void lockAccount(Authentication authentication) {
        Optional<LoginAttempt> loginAttempt = this.loginAttemptService.updateFailedAttempt(authentication.getName());
        if (loginAttempt.isPresent()) {
            if (loginAttempt.get().getFailedAttempts() == 5) {
                throw new LockedException(this.messages.getMessage(ACCOUNT_LOCKED_MSG_KEY, ACCOUNT_LOCKED_DEFAULT_MSG));
            }
            if (loginAttempt.get().getFailedAttempts() > 2) {
                throw new BadCredentialsException(String.format(TOO_MANY_ATTEMPTS_MSG_FORMAT, 5 - loginAttempt.get().getFailedAttempts()));
            }
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) {
        HashMap authenticationCredentials = (HashMap)authentication.getCredentials();
        if (authenticationCredentials == null || !this.passwordEncoder.matches((CharSequence)authenticationCredentials.get("j_password"), userDetails.getPassword())) {
            throw new BadCredentialsException(this.messages.getMessage(BAD_CRED_MSG_KEY, BAD_CRED_DEFAULT_MSG));
        }
    }
}

