/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.security.authentication.listener;

import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.audit.entity.LoginAudit;
import org.egov.infra.security.audit.service.LoginAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class UserSessionDestroyListener
implements HttpSessionListener {
    @Autowired
    private LoginAuditService loginAuditService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="entityValidator")
    private LocalValidatorFactoryBean entityValidator;
    @Value(value="${master.server}")
    private boolean masterServer;

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.masterServer) {
            this.auditUserLogin(event.getSession());
        }
    }

    private void auditUserLogin(HttpSession session) {
        if (session.getAttribute("login_ip") != null) {
            try {
                ApplicationThreadLocals.setTenantID((String)session.getAttribute("tenant_id"));
                LoginAudit loginAudit = new LoginAudit();
                loginAudit.setLoginTime((Date)session.getAttribute("login_time"));
                loginAudit.setUser(this.userService.getUserById((Long)session.getAttribute("userid")));
                loginAudit.setIpAddress((String)session.getAttribute("login_ip"));
                loginAudit.setUserAgent((String)session.getAttribute("login_user_agent"));
                loginAudit.setLogoutTime(new Date());
                if (this.entityValidator.validate((Object)loginAudit, new Class[0]).isEmpty()) {
                    this.loginAuditService.auditLogin(loginAudit);
                }
            }
            finally {
                ApplicationThreadLocals.clearValues();
            }
        }
    }
}

