/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.security.authentication.handler;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Component;

@Component
public class ApplicationLogoutHandler
implements LogoutHandler {
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.clearAllCookies(request, response);
    }

    private void clearAllCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length < 1) {
            return;
        }
        for (Cookie cookie : cookies) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            cookie.setValue(null);
            response.addCookie(cookie);
        }
    }
}

