/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.security.authentication.handler;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.egov.infra.config.security.authentication.userdetail.CurrentUser;
import org.egov.infra.security.audit.service.LoginAttemptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class ApplicationAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    @Autowired
    private LoginAttemptService loginAttemptService;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private Pattern excludedUrls;

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    public void setExcludedUrlRegex(String excludedUrlRegex) {
        this.excludedUrls = Pattern.compile(excludedUrlRegex);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        this.auditLoginDetails(request, authentication);
        this.resetFailedLoginAttempt(authentication);
        this.redirectToSuccessPage(request, response, authentication);
    }

    private void redirectToSuccessPage(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest == null) {
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        String targetUrlParameter = this.getTargetUrlParameter();
        if (this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter))) {
            this.requestCache.removeRequest(request, response);
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        this.clearAuthenticationAttributes(request);
        String targetUrl = savedRequest.getRedirectUrl();
        if (this.excludedUrls.matcher(targetUrl).find()) {
            targetUrl = this.getDefaultTargetUrl();
        }
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }

    private void auditLoginDetails(HttpServletRequest request, Authentication authentication) {
        HashMap credentials = (HashMap)authentication.getCredentials();
        HttpSession session = request.getSession(false);
        session.setAttribute("login_time", (Object)new Date());
        session.setAttribute("login_ip", credentials.get("ipAddress"));
        session.setAttribute("login_user_agent", credentials.get("userAgentInfo"));
    }

    private void resetFailedLoginAttempt(Authentication authentication) {
        this.loginAttemptService.resetFailedAttempt(((CurrentUser)authentication.getPrincipal()).getUsername());
    }
}

