/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.redis;

import java.util.List;
import org.egov.infra.config.redis.EmbeddedRedisServer;
import org.egov.infra.config.redis.RedisServerConfigCondition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisServerConfiguration {
    @Value(value="${redis.enable.embedded}")
    private boolean usingEmbeddedRedis;
    @Value(value="${redis.enable.sentinel}")
    private boolean sentinelEnabled;
    @Value(value="${redis.host.name}")
    private String redisHost;
    @Value(value="${redis.host.port}")
    private Integer redisPort;
    @Value(value="${redis.sentinel.master.name}")
    private String sentinelMasterName;
    @Value(value="#{'${redis.sentinel.hosts}'.split(',')}")
    private List<String> sentinelHosts;

    @Bean
    @Conditional(value={RedisServerConfigCondition.class})
    public static EmbeddedRedisServer redisServer() {
        return new EmbeddedRedisServer();
    }

    @Bean
    public JedisConnectionFactory redisConnectionFactory() {
        if (!this.usingEmbeddedRedis && this.sentinelEnabled) {
            RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration();
            sentinelConfig.master(this.sentinelMasterName);
            for (String host : this.sentinelHosts) {
                String[] hostConfig = host.split(":");
                sentinelConfig.sentinel(hostConfig[0].trim(), Integer.valueOf(hostConfig[1].trim()));
            }
            return new JedisConnectionFactory(sentinelConfig, this.redisPoolConfig());
        }
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.redisPoolConfig());
        jedisConnectionFactory.setHostName(this.redisHost);
        jedisConnectionFactory.setPort(this.redisPort.intValue());
        return jedisConnectionFactory;
    }

    @Bean
    public JedisPoolConfig redisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setMinEvictableIdleTimeMillis(60000L);
        jedisPoolConfig.setSoftMinEvictableIdleTimeMillis(1800000L);
        jedisPoolConfig.setNumTestsPerEvictionRun(-1);
        jedisPoolConfig.setTestOnReturn(false);
        jedisPoolConfig.setTestWhileIdle(true);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(30000L);
        return jedisPoolConfig;
    }

    @Bean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory cf) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(cf);
        return redisTemplate;
    }
}

