/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.multitenancy;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MultiTenantSchemaConnectionProvider
implements MultiTenantConnectionProvider {
    private static final long serialVersionUID = -6022082859572861041L;
    private static final Logger LOG = LoggerFactory.getLogger(MultiTenantSchemaConnectionProvider.class);
    @Autowired
    private transient DataSource dataSource;

    public Connection getAnyConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void releaseAnyConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public Connection getConnection(String tenantId) {
        try {
            Connection connection = this.getAnyConnection();
            connection.setSchema(tenantId);
            return connection;
        }
        catch (SQLException e) {
            LOG.error("Error occurred while switching tenant schema upon getting connection", (Throwable)e);
            throw new HibernateException("Could not alter JDBC connection to specified schema [" + tenantId + "]", (Throwable)e);
        }
    }

    public void releaseConnection(String tenantId, Connection connection) throws SQLException {
        try {
            connection.setSchema(tenantId);
        }
        catch (SQLException e) {
            LOG.warn("Error occurred while switching schema upon release connection", (Throwable)e);
        }
        this.releaseAnyConnection(connection);
    }

    public boolean supportsAggressiveRelease() {
        return Boolean.TRUE;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return MultiTenantConnectionProvider.class.equals((Object)unwrapType) || AbstractMultiTenantConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }
}

