/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.datasource.routing;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.infra.config.persistence.datasource.routing.DatasourceType;
import org.egov.infra.config.persistence.datasource.routing.RoutingDatasource;
import org.egov.infra.config.persistence.datasource.routing.RoutingDatasourceConfigCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration
@Conditional(value={RoutingDatasourceConfigCondition.class})
public class RoutingDatasourceConfiguration {
    @Autowired
    private Environment env;

    @Bean(name={"readWriteDataSource"})
    public JndiObjectFactoryBean readWriteDataSource() {
        JndiObjectFactoryBean dataSource = new JndiObjectFactoryBean();
        dataSource.setExpectedType(DataSource.class);
        dataSource.setJndiName(this.env.getProperty("default.jdbc.jndi.datasource"));
        return dataSource;
    }

    @Bean(name={"readOnlyDataSource"})
    public JndiObjectFactoryBean readOnlyDataSource() {
        JndiObjectFactoryBean dataSource = new JndiObjectFactoryBean();
        dataSource.setExpectedType(DataSource.class);
        dataSource.setJndiName(this.env.getProperty("default.jdbc.jndi.readonly.datasource"));
        return dataSource;
    }

    @Bean(name={"dataSource"})
    public RoutingDatasource dataSource(DataSource readWriteDataSource, DataSource readOnlyDataSource) {
        RoutingDatasource routingDataSource = new RoutingDatasource();
        HashMap<DatasourceType, DataSource> dataSources = new HashMap<DatasourceType, DataSource>();
        dataSources.put(DatasourceType.READONLY, readOnlyDataSource);
        dataSources.put(DatasourceType.READWRITE, readWriteDataSource);
        routingDataSource.setTargetDataSources(dataSources);
        routingDataSource.setDefaultTargetDataSource(readWriteDataSource);
        return routingDataSource;
    }
}

