/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.notification.listener;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.egov.infra.notification.entity.NotificationPriority;
import org.egov.infra.notification.service.SMSService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.stereotype.Component;

@Component
public class SMSNotificationListener {
    @Autowired
    private SMSService smsService;

    @JmsListener(destination="java:/jms/queue/sms")
    public void processMessage(Message message) {
        try {
            MapMessage emailMessage = (MapMessage)message;
            this.smsService.sendSMS(emailMessage.getString("mobile"), emailMessage.getString("message"), NotificationPriority.valueOf(emailMessage.getString("priority")));
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
    }
}

