/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.notification.listener;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.egov.infra.notification.service.EmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.stereotype.Component;

@Component
public class EmailNotificationListener {
    @Autowired
    private EmailService emailService;

    @JmsListener(destination="java:/jms/queue/email")
    public void onMessage(Message message) {
        try {
            MapMessage emailMessage = (MapMessage)message;
            if (emailMessage.itemExists("filetype")) {
                this.emailService.sendEmail(emailMessage.getString("email"), emailMessage.getString("subject"), emailMessage.getString("message"), emailMessage.getString("filetype"), emailMessage.getString("filename"), emailMessage.getBytes("attachment"));
            } else {
                this.emailService.sendEmail(emailMessage.getString("email"), emailMessage.getString("subject"), emailMessage.getString("message"));
            }
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
    }
}

