/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.notification;

import javax.jms.Destination;
import org.egov.infra.config.notification.listener.EmailNotificationListener;
import org.egov.infra.config.notification.listener.SMSNotificationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration
@DependsOn(value={"jmsConfiguration"})
public class NotificationConfiguration {
    @Bean(name={"smsQueue"})
    public JndiObjectFactoryBean smsQueue() {
        JndiObjectFactoryBean smsQueue = new JndiObjectFactoryBean();
        smsQueue.setExpectedType(Destination.class);
        smsQueue.setResourceRef(true);
        smsQueue.setJndiName("java:/jms/queue/sms");
        return smsQueue;
    }

    @Bean(name={"emailQueue"})
    public JndiObjectFactoryBean emailQueue() {
        JndiObjectFactoryBean emailQueue = new JndiObjectFactoryBean();
        emailQueue.setExpectedType(Destination.class);
        emailQueue.setResourceRef(true);
        emailQueue.setJndiName("java:/jms/queue/email");
        return emailQueue;
    }

    @Bean
    public EmailNotificationListener emailNotificationListener() {
        return new EmailNotificationListener();
    }

    @Bean
    public SMSNotificationListener smsNotificationListener() {
        return new SMSNotificationListener();
    }
}

