/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.messaging;

import javax.jms.ConnectionFactory;
import org.egov.infra.config.messaging.MessagingErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@EnableJms
@Configuration
public class MessagingListenerConfiguration {
    @Bean(value={"jmsListenerContainerFactory"})
    public DefaultJmsListenerContainerFactory jmsQueueListenerContainerFactory(CachingConnectionFactory cachingConnectionFactory, PlatformTransactionManager transactionManager, JndiDestinationResolver jmsDestinationResolver) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = new DefaultJmsListenerContainerFactory();
        listenerContainerFactory.setConnectionFactory((ConnectionFactory)cachingConnectionFactory);
        listenerContainerFactory.setTransactionManager(transactionManager);
        listenerContainerFactory.setErrorHandler((ErrorHandler)this.messagingErrorHandler());
        listenerContainerFactory.setDestinationResolver((DestinationResolver)jmsDestinationResolver);
        listenerContainerFactory.setConcurrency("10");
        return listenerContainerFactory;
    }

    @Bean
    public DefaultJmsListenerContainerFactory jmsTopicListenerContainerFactory(CachingConnectionFactory cachingConnectionFactory, PlatformTransactionManager transactionManager, JndiDestinationResolver jmsDestinationResolver) {
        DefaultJmsListenerContainerFactory listenerContainerFactory = new DefaultJmsListenerContainerFactory();
        listenerContainerFactory.setConnectionFactory((ConnectionFactory)cachingConnectionFactory);
        listenerContainerFactory.setTransactionManager(transactionManager);
        listenerContainerFactory.setErrorHandler((ErrorHandler)this.messagingErrorHandler());
        listenerContainerFactory.setDestinationResolver((DestinationResolver)jmsDestinationResolver);
        listenerContainerFactory.setPubSubDomain(Boolean.valueOf(true));
        listenerContainerFactory.setConcurrency("10");
        return listenerContainerFactory;
    }

    @Bean
    public MessagingErrorHandler messagingErrorHandler() {
        return new MessagingErrorHandler();
    }
}

