/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.messaging;

import javax.jms.ConnectionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration(value="jmsConfiguration")
public class MessagingConfiguration {
    @Bean(name={"jmsDestinationResolver"})
    public JndiDestinationResolver jmsDestinationResolver() {
        JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
        jndiDestinationResolver.setResourceRef(true);
        return jndiDestinationResolver;
    }

    @Bean(name={"jmsConnectionFactory"})
    public JndiObjectFactoryBean jmsConnectionFactory() {
        JndiObjectFactoryBean jmsConnectionFactory = new JndiObjectFactoryBean();
        jmsConnectionFactory.setExpectedType(ConnectionFactory.class);
        jmsConnectionFactory.setJndiName("java:/ConnectionFactory");
        return jmsConnectionFactory;
    }

    @Bean(name={"cacheConnectionFactory"})
    public CachingConnectionFactory cacheConnectionFactory(ConnectionFactory jmsConnectionFactory) {
        CachingConnectionFactory cacheConnectionFactory = new CachingConnectionFactory();
        cacheConnectionFactory.setTargetConnectionFactory(jmsConnectionFactory);
        cacheConnectionFactory.setSessionCacheSize(10);
        cacheConnectionFactory.setCacheProducers(false);
        return cacheConnectionFactory;
    }

    @Bean
    public JmsTemplate jmsTemplate(CachingConnectionFactory cacheConnectionFactory) {
        return new JmsTemplate((ConnectionFactory)cacheConnectionFactory);
    }
}

