/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.elasticsearch;

import java.net.InetSocketAddress;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(basePackages={"org.egov.**.repository.es", "org.egov.**.elasticsearch.repository"})
public class ElasticSearchConfiguration {
    @Value(value="${elasticsearch.cluster.name}")
    private String clusterName;
    @Value(value="#{'${elasticsearch.hosts}'.split(',')}")
    private List<String> searchHosts;
    @Value(value="${elasticsearch.port}")
    private Integer searchPort;

    private Client transportClient() {
        Settings settings = Settings.settingsBuilder().put("cluster.name", this.clusterName).build();
        TransportClient client = TransportClient.builder().settings(settings).build();
        this.searchHosts.forEach(arg_0 -> this.lambda$transportClient$0((Client)client, arg_0));
        return client;
    }

    @Bean
    public ElasticsearchOperations elasticsearchTemplate() {
        return new ElasticsearchTemplate(this.transportClient());
    }

    private /* synthetic */ void lambda$transportClient$0(Client client, String host) {
        ((TransportClient)client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(host, (int)this.searchPort)));
    }
}

