/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.core;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentSettings {
    private static final String DEV_MODE = "dev.mode";
    private static final String MAIL_ENABLED = "mail.enabled";
    private static final String SMS_ENABLED = "sms.enabled";
    private static final String USER_PASWRD_EXPIRY_DAYS = "user.pwd.expiry.days";
    private static final String HIBERNATE_JDBC_BATCH_SIZE = "hibernate.jdbc.batch_size";
    private static final String STATE_WIDE_SCHEMA_NAME = "statewide.schema.name";
    private static final String DEFAULT_SCHEMA_NAME = "default.schema.name";
    @Autowired
    private Environment environment;

    public String getProperty(String propKey) {
        return this.environment.getProperty(propKey, "");
    }

    public <T> T getProperty(String propKey, Class<T> type) {
        return (T)this.environment.getProperty(propKey, type);
    }

    public boolean devMode() {
        return (Boolean)this.environment.getProperty(DEV_MODE, Boolean.class);
    }

    public boolean emailEnabled() {
        return (Boolean)this.environment.getProperty(MAIL_ENABLED, Boolean.class);
    }

    public boolean smsEnabled() {
        return (Boolean)this.environment.getProperty(SMS_ENABLED, Boolean.class);
    }

    public Integer userPasswordExpiryInDays() {
        return (Integer)this.environment.getProperty(USER_PASWRD_EXPIRY_DAYS, Integer.class);
    }

    public Integer getBatchUpdateSize() {
        return (Integer)this.environment.getProperty(HIBERNATE_JDBC_BATCH_SIZE, Integer.class);
    }

    public String statewideSchemaName() {
        return this.environment.getProperty(STATE_WIDE_SCHEMA_NAME);
    }

    public String defaultSchemaName() {
        return this.environment.getProperty(DEFAULT_SCHEMA_NAME);
    }

    public String schemaName(String domainName) {
        return this.environment.getProperty("tenant." + domainName, this.defaultSchemaName());
    }
}

