/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.engine.jasper.JasperReportService;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class ApplicationConfiguration {
    @Resource(name="tenants")
    private List<String> tenants;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EnvironmentSettings environmentSettings;
    @Value(value="${filestoreservice.beanname}")
    private String fileStoreServiceBeanName;

    @Bean
    public FileStoreService fileStoreService() {
        return (FileStoreService)this.context.getBean(this.fileStoreServiceBeanName);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    @Bean(name={"cities"}, autowire=Autowire.BY_NAME)
    @DependsOn(value={"tenants"})
    public List<String> cities() {
        ArrayList<String> cities = new ArrayList<String>(this.tenants);
        if (!this.environmentSettings.devMode()) {
            cities.remove(this.environmentSettings.statewideSchemaName());
        }
        return cities;
    }

    @Bean
    public LocalValidatorFactoryBean entityValidator() {
        return new LocalValidatorFactoryBean();
    }

    @Bean
    public ReportService reportService() {
        return new JasperReportService(10, 30);
    }

    @PostConstruct
    public void enhanceSystemProperties() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setTargetObject((Object)System.getProperties());
        methodInvokingFactoryBean.setTargetMethod("putAll");
        Properties properties = new Properties();
        properties.setProperty("default.time.zone", this.environmentSettings.getProperty("default.time.zone"));
        properties.setProperty("default.country.code", this.environmentSettings.getProperty("default.country.code"));
        properties.setProperty("default.currency.code", this.environmentSettings.getProperty("default.currency.code"));
        properties.setProperty("default.currency.name", this.environmentSettings.getProperty("default.currency.name"));
        properties.setProperty("default.currency.name.short", this.environmentSettings.getProperty("default.currency.name.short"));
        properties.setProperty("default.currency.symbol.utf-8", this.environmentSettings.getProperty("default.currency.symbol.utf-8"));
        properties.setProperty("default.currency.symbol.hex", this.environmentSettings.getProperty("default.currency.symbol.hex"));
        properties.setProperty("default.locale", this.environmentSettings.getProperty("default.locale"));
        properties.setProperty("default.encoding", this.environmentSettings.getProperty("default.encoding"));
        properties.setProperty("default.date.pattern", this.environmentSettings.getProperty("default.date.pattern"));
        properties.setProperty("default.date.time.pattern", this.environmentSettings.getProperty("default.date.time.pattern"));
        methodInvokingFactoryBean.setArguments(new Object[]{properties});
        methodInvokingFactoryBean.prepare();
        methodInvokingFactoryBean.invoke();
    }
}

