/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.UserRepository;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.microservice.utils.MicroserviceUtils;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.persistence.entity.enums.UserType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UserService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MicroserviceUtils microserviceUtils;

    @Transactional
    public User updateUser(User user) {
        return (User)this.userRepository.saveAndFlush(user);
    }

    @Transactional
    public User createUser(User user) {
        User savedUser = (User)this.userRepository.save(user);
        this.microserviceUtils.createUserMicroservice(user);
        return savedUser;
    }

    public Set<Role> getRolesByUsername(String userName) {
        return this.userRepository.findUserRolesByUserName(userName);
    }

    public User getUserById(Long id) {
        return (User)this.userRepository.findOne(id);
    }

    public User getUserRefById(Long id) {
        return (User)this.userRepository.getOne(id);
    }

    public User getCurrentUser() {
        return (User)this.userRepository.findOne(ApplicationThreadLocals.getUserId());
    }

    public User getUserByUsername(String userName) {
        return this.userRepository.findByUsername(userName);
    }

    public List<User> getUsersByNameLike(String userName) {
        return this.userRepository.findByNameContainingIgnoreCase(userName);
    }

    public User getUserByEmailId(String emailId) {
        return this.userRepository.findByEmailId(emailId);
    }

    public User getUserByAadhaarNumber(String aadhaarNumber) {
        return this.userRepository.findByAadhaarNumber(aadhaarNumber);
    }

    public List<User> getUserByAadhaarNumberAndType(String aadhaarNumber, UserType type) {
        return this.userRepository.findByAadhaarNumberAndType(aadhaarNumber, type);
    }

    public Optional<User> checkUserWithIdentity(String identity) {
        return Optional.ofNullable(this.getUserByUsername(identity));
    }

    public List<User> findAllByMatchingUserNameForType(String username, UserType type) {
        return this.userRepository.findByUsernameContainingIgnoreCaseAndTypeAndActiveTrue(username, type);
    }

    public Set<User> getUsersByRoleName(String roleName) {
        return this.userRepository.findUsersByRoleName(roleName);
    }

    public List<User> getAllEmployeeNameLike(String name) {
        return this.userRepository.findByNameContainingIgnoreCaseAndTypeAndActiveTrue(name, UserType.EMPLOYEE);
    }

    public List<User> getUsersByUsernameAndRolename(String userName, String roleName) {
        return this.userRepository.findUsersByUserAndRoleName(userName, roleName);
    }

    public User getUserByNameAndMobileNumberForGender(String name, String mobileNumber, Gender gender) {
        return this.userRepository.findByNameAndMobileNumberAndGender(name, mobileNumber, gender);
    }
}

