/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.contracts.CrossHierarchyRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.repository.CrossHierarchyRepository;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CrossHierarchyService {
    private static final String CROSS_HIERARCHY_BOUNDARYTYPES = "CrosshierarchyBoundaryTypes";
    private static final String ADMINISTRATION = "Administration";
    @Autowired
    private CrossHierarchyRepository crossHierarchyRepository;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private AppConfigValueService appConfigValueService;

    @Transactional
    public void addOrRemoveCrossHierarchy(CrossHierarchyRequest crossHierarchyRequest) {
        List<CrossHierarchy> existingCrossHierarchy;
        Boundary boundary = crossHierarchyRequest.getBoundary();
        List<Boundary> existingBoundaries = this.getActiveChildBoundariesByParentId(boundary.getId());
        List<Boundary> mappedBoundaries = crossHierarchyRequest.getBoundaries();
        existingBoundaries.removeAll(mappedBoundaries);
        for (Boundary existingBoundary : existingBoundaries) {
            existingCrossHierarchy = this.getAllByParentAndChildBoundaryId(boundary.getId(), existingBoundary.getId());
            if (existingCrossHierarchy.isEmpty()) continue;
            this.crossHierarchyRepository.delete(existingCrossHierarchy);
        }
        for (Boundary mappedBoundary : new HashSet<Boundary>(mappedBoundaries)) {
            existingCrossHierarchy = this.getAllByParentAndChildBoundaryId(boundary.getId(), mappedBoundary.getId());
            if (!existingCrossHierarchy.isEmpty()) continue;
            CrossHierarchy crossHierarchy = new CrossHierarchy();
            crossHierarchy.setChild(mappedBoundary);
            crossHierarchy.setParent(boundary);
            crossHierarchy.setParentType(crossHierarchyRequest.getBoundaryType());
            crossHierarchy.setChildType(mappedBoundary.getBoundaryType());
            this.crossHierarchyRepository.save(crossHierarchy);
        }
    }

    public List<CrossHierarchy> getChildBoundaryNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName, String parenthierarchyTypeName, String name) {
        return this.crossHierarchyRepository.findByChildBoundaryNameAndBoundaryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName, parenthierarchyTypeName, name);
    }

    public List<Boundary> getChildBoundariesNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName) {
        return this.crossHierarchyRepository.findChildBoundariesByBoundaryTypeAndHierarchyTypeNames(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getParentBoundaryByChildBoundaryAndParentBoundaryType(Long childId, Long parentTypeId) {
        return this.crossHierarchyRepository.findParentBoundariesByChildBoundaryAndParentBoundaryTypeIds(childId, parentTypeId);
    }

    public List<Boundary> getActiveChildBoundariesByParentId(Long parentId) {
        return this.crossHierarchyRepository.findChildBoundariesByActiveParentBoundaryId(parentId);
    }

    public CrossHierarchy findById(Long id) {
        return (CrossHierarchy)this.crossHierarchyRepository.findOne(id);
    }

    public List<Boundary> findChildBoundariesByParentBoundary(String boundaryTypeName, String hierarchyTypeName, String parentBoundary) {
        return this.crossHierarchyRepository.findChildBoundariesByParentBoundary(boundaryTypeName, hierarchyTypeName, parentBoundary);
    }

    public List<CrossHierarchy> getAllByParentAndChildBoundaryId(Long parentId, Long childId) {
        return this.crossHierarchyRepository.findByParentIdAndChildId(parentId, childId);
    }

    public List<Boundary> getBoundaryByBoundaryType() {
        return this.boundaryService.getActiveBoundariesByBoundaryTypeId(this.boundaryTypeService.getBoundaryTypeByName("Locality").getId());
    }

    public List<BoundaryType> getCrossHierarchyBoundaryTypes() {
        ArrayList<BoundaryType> boundaryTypes = new ArrayList<BoundaryType>();
        String appConfigValue = this.appConfigValueService.getConfigValuesByModuleAndKey(ADMINISTRATION, CROSS_HIERARCHY_BOUNDARYTYPES).get(0).getValue();
        if (StringUtils.isNotBlank((CharSequence)appConfigValue)) {
            for (String value : appConfigValue.split(",")) {
                String[] boundaryTypeAndHierarchyTypeNames = value.split("-");
                boundaryTypes.add(this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeAndHierarchyTypeNames[1], boundaryTypeAndHierarchyTypeNames[0]));
            }
        }
        return boundaryTypes;
    }
}

