/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.repository.CityRepository;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.utils.FileStoreUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CityService {
    private static final String CITY_DATA_CACHE_KEY = "%s-city-pref";
    private static final String CITY_LOGO_CACHE_KEY = "%s-city-logo";
    private static final String CITY_LOGO_HASH_KEY = "city-logo";
    private final CityRepository cityRepository;
    @Autowired
    private NotificationService notificationService;
    @Resource(name="redisTemplate")
    private HashOperations<String, String, Object> cityPrefCache;
    @Resource(name="redisTemplate")
    private HashOperations<String, String, Object> cityLogoCache;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;
    @Autowired
    private FileStoreUtils fileStoreUtils;

    @Autowired
    public CityService(CityRepository cityRepository) {
        this.cityRepository = cityRepository;
    }

    @Transactional
    public City updateCity(City city) {
        this.redisTemplate.delete((Object)this.cityPrefCacheKey());
        this.redisTemplate.delete((Object)this.cityLogoCacheKey());
        this.cityDataAsMap();
        return (City)this.cityRepository.save(city);
    }

    public City getCityByURL(String url) {
        return this.cityRepository.findByDomainURL(url);
    }

    public City getCityByName(String cityName) {
        return this.cityRepository.findByName(cityName);
    }

    public City getCityByCode(String code) {
        return this.cityRepository.findByCode(code);
    }

    public List<City> findAll() {
        return this.cityRepository.findAll();
    }

    public void sentFeedBackMail(String email, String subject, String message) {
        this.notificationService.sendEmail(email, subject, message);
    }

    public Map<String, Object> cityDataAsMap() {
        Map cityPrefs = this.cityPrefCache.entries((Object)this.cityPrefCacheKey());
        if (cityPrefs.isEmpty()) {
            this.cityPrefCache.putAll((Object)this.cityPrefCacheKey(), this.getCityByURL(ApplicationThreadLocals.getDomainName()).toMap());
            cityPrefs = this.cityPrefCache.entries((Object)this.cityPrefCacheKey());
        }
        return cityPrefs;
    }

    public String getCityCode() {
        return (String)this.cityDataForKey("cityCode");
    }

    public String getMunicipalityName() {
        return (String)this.cityDataForKey("citymunicipalityname");
    }

    public String getCityGrade() {
        return (String)this.cityDataForKey("cityGrade");
    }

    public String getContactEmail() {
        return (String)this.cityDataForKey("corpContactEmail");
    }

    public String getDistrictName() {
        return (String)this.cityDataForKey("districtName");
    }

    public String getCityLogoURL() {
        return String.format("%s/egi/downloadfile/logo", ApplicationThreadLocals.getDomainURL());
    }

    public byte[] getCityLogoAsBytes() {
        byte[] cityLogo = (byte[])this.cityLogoCache.get((Object)this.cityLogoCacheKey(), (Object)CITY_LOGO_HASH_KEY);
        if (cityLogo == null || cityLogo.length < 1) {
            cityLogo = this.fileStoreUtils.fileAsByteArray(this.getCityLogoFileStoreId(), this.getCityCode());
            this.cityLogoCache.put((Object)this.cityLogoCacheKey(), (Object)CITY_LOGO_HASH_KEY, (Object)cityLogo);
        }
        return cityLogo;
    }

    public String getCityLogoFileStoreId() {
        return (String)this.cityDataForKey("citylogo");
    }

    public Object cityDataForKey(String key) {
        return this.cityPrefCache.get((Object)this.cityPrefCacheKey(), (Object)key);
    }

    private String cityPrefCacheKey() {
        return String.format(CITY_DATA_CACHE_KEY, ApplicationThreadLocals.getTenantID());
    }

    private String cityLogoCacheKey() {
        return String.format(CITY_LOGO_CACHE_KEY, ApplicationThreadLocals.getTenantID());
    }
}

