/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.repository;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.QueryHint;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BoundaryRepository
extends JpaRepository<Boundary, Long> {
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Boundary findByName(String var1);

    public List<Boundary> findByNameContainingIgnoreCase(String var1);

    public List<Boundary> findByBoundaryTypeId(Long var1);

    public Page<Boundary> findByBoundaryTypeId(Long var1, Pageable var2);

    public Boundary findByBoundaryTypeAndBoundaryNum(BoundaryType var1, Long var2);

    @Query(value="select b from Boundary b where b.active=true AND b.boundaryType.id =:boundaryTypeId order by b.name")
    public List<Boundary> findActiveBoundariesByBoundaryTypeId(@Param(value="boundaryTypeId") Long var1);

    @Query(value="select b from Boundary b where b.active=true AND b.boundaryType.hierarchyType = :hierarchyType AND b.boundaryType.hierarchy = :hierarchyLevel AND ((b.toDate IS NULL AND b.fromDate <= :asOnDate) OR (b.toDate IS NOT NULL AND b.fromDate <= :asOnDate AND b.toDate >= :asOnDate)) order by b.name")
    public List<Boundary> findActiveBoundariesByHierarchyTypeAndLevelAndAsOnDate(@Param(value="hierarchyType") HierarchyType var1, @Param(value="hierarchyLevel") Long var2, @Param(value="asOnDate") Date var3);

    @Query(value="select b from Boundary b where b.active=true AND b.parent is not null AND b.parent.id = :parentBoundaryId AND ((b.toDate IS NULL AND b.fromDate <= :asOnDate) OR (b.toDate IS NOT NULL AND b.fromDate <= :asOnDate AND b.toDate >= :asOnDate)) order by b.name")
    public List<Boundary> findActiveChildBoundariesByBoundaryIdAndAsOnDate(@Param(value="parentBoundaryId") Long var1, @Param(value="asOnDate") Date var2);

    @Query(value="from Boundary BND where BND.active=true AND BND.materializedPath like (select B.materializedPath from Boundary B where B.id=:parentId)||'%'")
    public List<Boundary> findActiveChildrenWithParent(@Param(value="parentId") Long var1);

    @Query(value="from Boundary BND where BND.active=true AND BND.materializedPath in :mpath ")
    public List<Boundary> findActiveBoundariesForMpath(@Param(value="mpath") Set<String> var1);

    @Query(value="select b from Boundary b where b.parent is not null AND b.parent.id = :parentBoundaryId AND ((b.toDate IS NULL AND b.fromDate <= :asOnDate) OR (b.toDate IS NOT NULL AND b.fromDate <= :asOnDate AND b.toDate >= :asOnDate)) order by b.name")
    public List<Boundary> findChildBoundariesByBoundaryIdAndAsOnDate(@Param(value="parentBoundaryId") Long var1, @Param(value="asOnDate") Date var2);

    @Query(value="select b from Boundary b where b.active=true AND b.boundaryNum = :boundaryNum AND b.boundaryType.name = :boundaryType AND upper(b.boundaryType.hierarchyType.code) = :hierarchyTypeCode AND ((b.toDate IS NULL AND b.fromDate <= :asOnDate) OR (b.toDate IS NOT NULL AND b.fromDate <= :asOnDate AND b.toDate >= :asOnDate))")
    public Boundary findActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCodeAndAsOnDate(@Param(value="boundaryNum") Long var1, @Param(value="boundaryType") String var2, @Param(value="hierarchyTypeCode") String var3, @Param(value="asOnDate") Date var4);

    @Query(value="select b from Boundary b where b.active=true AND upper(b.boundaryType.name) = upper(:boundaryTypeName) AND upper(b.boundaryType.hierarchyType.name) = upper(:hierarchyTypeName) order by b.name")
    public List<Boundary> findActiveBoundariesByBndryTypeNameAndHierarchyTypeName(@Param(value="boundaryTypeName") String var1, @Param(value="hierarchyTypeName") String var2);

    @Query(value="select b from Boundary b where upper(b.boundaryType.name) = UPPER(:boundaryTypeName) AND upper(b.boundaryType.hierarchyType.name) = UPPER(:hierarchyTypeName) order by b.id")
    public List<Boundary> findBoundariesByBndryTypeNameAndHierarchyTypeName(@Param(value="boundaryTypeName") String var1, @Param(value="hierarchyTypeName") String var2);

    @Query(value="select b from Boundary b where upper(b.boundaryType.name) = UPPER(:boundaryTypeName) AND upper(b.boundaryType.hierarchyType.name) = UPPER(:hierarchyTypeName) order by b.id")
    public Boundary findBoundaryByBndryTypeNameAndHierarchyTypeName(@Param(value="boundaryTypeName") String var1, @Param(value="hierarchyTypeName") String var2);

    @Query(value="select b from Boundary b where b.active=true and UPPER(b.name) like UPPER(:boundaryName) and b.boundaryType.id=:boundaryTypeId order by b.boundaryNum asc")
    public List<Boundary> findByNameAndBoundaryTypeOrderByBoundaryNumAsc(@Param(value="boundaryName") String var1, @Param(value="boundaryTypeId") Long var2);

    @Query(value="select b from Boundary b where b.boundaryType.name=:boundaryType and b.boundaryType.hierarchyType.name=:hierarchyType and b.boundaryType.hierarchy=:hierarchyLevel")
    public Boundary findByBoundaryTypeNameAndHierarchyTypeNameAndLevel(@Param(value="boundaryType") String var1, @Param(value="hierarchyType") String var2, @Param(value="hierarchyLevel") Long var3);

    @Query(value="select b from Boundary b where b.active=true AND upper(b.boundaryType.name) = upper(:boundaryTypeName) AND upper(b.boundaryType.hierarchyType.name) = upper(:hierarchyTypeName) AND UPPER(b.name) like UPPER(:name)||'%' order by b.id")
    public List<Boundary> findActiveBoundariesByNameAndBndryTypeNameAndHierarchyTypeName(@Param(value="boundaryTypeName") String var1, @Param(value="hierarchyTypeName") String var2, @Param(value="name") String var3);

    @Query(value="from Boundary BND where BND.active=true AND BND.parent.id=:parentId)")
    public List<Boundary> findActiveImmediateChildrenWithOutParent(@Param(value="parentId") Long var1);

    @Query(value="from Boundary BND where BND.parent is null")
    public List<Boundary> findAllParents();

    public List<Boundary> findByBoundaryTypeOrderByBoundaryNumAsc(BoundaryType var1);
}

