/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Unique(fields={"name"}, enableDfltMsg=true)
@Table(name="eg_role")
@SequenceGenerator(name="SEQ_EG_ROLE", sequenceName="SEQ_EG_ROLE", allocationSize=1)
public class Role
extends AbstractAuditable {
    public static final String SEQ_ROLE = "SEQ_EG_ROLE";
    private static final long serialVersionUID = 7034114743461088547L;
    @Id
    @GeneratedValue(generator="SEQ_EG_ROLE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=32)
    private String name;
    @SafeHtml
    @Length(max=150)
    private String description;
    private boolean internal;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.getName(), role.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

