/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EG_BOUNDARY_TYPE")
@Unique(fields={"code"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EG_BOUNDARY_TYPE", sequenceName="SEQ_EG_BOUNDARY_TYPE", allocationSize=1)
public class BoundaryType
extends AbstractAuditable {
    public static final String SEQ_BOUNDARY_TYPE = "SEQ_EG_BOUNDARY_TYPE";
    private static final long serialVersionUID = 859229842367886336L;
    @Expose
    @Id
    @GeneratedValue(generator="SEQ_EG_BOUNDARY_TYPE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    private String name;
    @NotBlank
    @Length(max=25)
    @SafeHtml
    private String code;
    @ManyToOne
    @NotNull
    @JoinColumn(name="hierarchytype")
    private HierarchyType hierarchyType;
    @ManyToOne
    @JoinColumn(name="parent")
    private BoundaryType parent;
    private Long hierarchy;
    @SafeHtml
    private String localName;
    @Transient
    private String parentName;
    @Transient
    private Set<BoundaryType> childBoundaryTypes;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public HierarchyType getHierarchyType() {
        return this.hierarchyType;
    }

    public void setHierarchyType(HierarchyType hierarchyType) {
        this.hierarchyType = hierarchyType;
    }

    public BoundaryType getParent() {
        return this.parent;
    }

    public void setParent(BoundaryType parent) {
        this.parent = parent;
    }

    public Long getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(Long hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Set<BoundaryType> getChildBoundaryTypes() {
        return this.childBoundaryTypes;
    }

    public void setChildBoundaryTypes(Set<BoundaryType> childBoundaryTypes) {
        this.childBoundaryTypes = childBoundaryTypes;
    }

    public void addChildBoundaryType(BoundaryType boundaryType) {
        boundaryType.setParent(this);
        this.childBoundaryTypes.add(boundaryType);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoundaryType)) {
            return false;
        }
        BoundaryType that = (BoundaryType)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.hierarchyType, (Object)that.hierarchyType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.hierarchyType});
    }
}

