/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@CompositeUnique(fields={"boundaryNum", "boundaryType"}, enableDfltMsg=true)
@Unique(fields={"code"}, enableDfltMsg=true)
@Table(name="EG_BOUNDARY")
@NamedQuery(name="Boundary.findBoundariesByBoundaryType", query="select b from Boundary b where b.boundaryType.id = :boundaryTypeId")
@SequenceGenerator(name="seq_eg_boundary", sequenceName="seq_eg_boundary", allocationSize=1)
public class Boundary
extends AbstractAuditable {
    public static final String SEQ_BOUNDARY = "seq_eg_boundary";
    private static final long serialVersionUID = 3054956514161912026L;
    @Expose
    @Id
    @GeneratedValue(generator="seq_eg_boundary", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=512)
    @SafeHtml
    @NotBlank
    private String name;
    @Length(max=25)
    @SafeHtml
    @NotBlank
    private String code;
    private Long boundaryNum;
    @ManyToOne
    @JoinColumn(name="boundaryType", updatable=false)
    private BoundaryType boundaryType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SELECT)
    private Boundary parent;
    @OneToMany(cascade={CascadeType.REMOVE})
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SUBSELECT)
    @JsonIgnore
    private Set<Boundary> children = new HashSet<Boundary>();
    @DateFormat
    @DateTimeFormat(pattern="dd-MM-yyyy")
    private Date fromDate;
    private Date toDate;
    private boolean active;
    private Long bndryId;
    @SafeHtml
    private String localName;
    private Float longitude;
    private Float latitude;
    @Length(max=32)
    private String materializedPath;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String boundaryNameLocal) {
        this.localName = boundaryNameLocal;
    }

    public Boundary getParent() {
        return this.parent;
    }

    public void setParent(Boundary parent) {
        this.parent = parent;
    }

    public Set<Boundary> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Boundary> boundaries) {
        this.children = boundaries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public BoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    public void setBoundaryType(BoundaryType boundaryType) {
        this.boundaryType = boundaryType;
    }

    public Long getBoundaryNum() {
        return this.boundaryNum;
    }

    public void setBoundaryNum(Long number) {
        this.boundaryNum = number;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Long getBndryId() {
        return this.bndryId;
    }

    public void setBndryId(Long bndryId) {
        this.bndryId = bndryId;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public String getMaterializedPath() {
        return this.materializedPath;
    }

    public void setMaterializedPath(String materializedPath) {
        this.materializedPath = materializedPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Boundary)) {
            return false;
        }
        Boundary boundary = (Boundary)other;
        return Objects.equal((Object)this.boundaryNum, (Object)boundary.boundaryNum) && Objects.equal((Object)this.boundaryType, (Object)boundary.boundaryType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.boundaryNum, this.boundaryType});
    }
}

