/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.common.service;

import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.egov.infra.admin.common.entity.IdentityRecovery;
import org.egov.infra.admin.common.repository.IdentityRecoveryRepository;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.notification.entity.NotificationPriority;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.utils.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class IdentityRecoveryService {
    private static final String USER_PWD_RECOVERY_TEMPLATE = "user.pwd.recovery";
    @Autowired
    private IdentityRecoveryRepository identityRecoveryRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EnvironmentSettings environmentSettings;

    public Optional<IdentityRecovery> getByToken(String token) {
        return Optional.ofNullable(this.identityRecoveryRepository.findByToken(token));
    }

    @Transactional
    public IdentityRecovery generate(User user, Date timeToExpire, boolean byOTP) {
        IdentityRecovery identityRecovery = new IdentityRecovery();
        identityRecovery.setToken(byOTP ? StringUtils.uniqueString(5).toUpperCase() : UUID.randomUUID().toString());
        identityRecovery.setUser(user);
        identityRecovery.setExpiry(timeToExpire);
        return (IdentityRecovery)this.identityRecoveryRepository.save(identityRecovery);
    }

    @Transactional
    public boolean generateAndSendUserPasswordRecovery(String identity, String urlToSent, boolean byOTP) {
        Optional<User> user = this.userService.checkUserWithIdentity(identity);
        if (user.isPresent()) {
            IdentityRecovery identityRecovery = this.generate(user.get(), new DateTime().plusMinutes(5).toDate(), byOTP);
            if (byOTP) {
                String message = "Your OTP for recovering password is " + identityRecovery.getToken();
                this.notificationService.sendSMS(user.get().getMobileNumber(), message, NotificationPriority.HIGH);
                this.notificationService.sendEmail(user.get().getEmailId(), "Password Reset", message);
            } else {
                this.notificationService.sendEmail(identityRecovery.getUser(), "Password Recovery", USER_PWD_RECOVERY_TEMPLATE, urlToSent, identityRecovery.getToken(), System.lineSeparator());
            }
        }
        return user.isPresent();
    }

    @Transactional
    public boolean validateAndResetPassword(String token, String newPassword) {
        boolean recoverd = false;
        Optional<IdentityRecovery> identityRecovery = this.getByToken(token);
        if (identityRecovery.isPresent()) {
            IdentityRecovery idRecovery = identityRecovery.get();
            if (idRecovery.getExpiry().isAfterNow()) {
                User user = idRecovery.getUser();
                user.updateNextPwdExpiryDate(this.environmentSettings.userPasswordExpiryInDays());
                user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
                this.userService.updateUser(user);
                recoverd = true;
            }
            this.identityRecoveryRepository.delete(idRecovery);
        }
        return recoverd;
    }

    public boolean tokenValid(String token) {
        Optional<IdentityRecovery> identityRecovery = this.getByToken(token);
        return identityRecovery.isPresent() && identityRecovery.get().getExpiry().isAfterNow();
    }
}

