/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.common.service;

import org.egov.infra.admin.common.entity.Favourites;
import org.egov.infra.admin.common.repository.FavouritesRepository;
import org.egov.infra.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FavouritesService {
    @Autowired
    private FavouritesRepository favouritesRepository;
    @Autowired
    private SecurityUtils securityUtils;

    public Favourites getFavouriteByUserIdAndActionId(Long userId, Integer actionId) {
        return this.favouritesRepository.findByUserIdAndActionId(userId, actionId);
    }

    @Transactional
    public boolean removeFromCurrentUserFavourite(Integer actionId) {
        Favourites favourites = this.getFavouriteByUserIdAndActionId(this.securityUtils.getCurrentUser().getId(), actionId);
        if (favourites == null) {
            return Boolean.FALSE;
        }
        this.favouritesRepository.delete(favourites);
        return Boolean.TRUE;
    }

    @Transactional
    public Favourites addToCurrentUserFavourite(Favourites favourites) {
        Long userId = this.securityUtils.getCurrentUser().getId();
        if (this.getFavouriteByUserIdAndActionId(userId, favourites.getActionId()) == null) {
            favourites.setUserId(userId);
            this.favouritesRepository.save(favourites);
        }
        return favourites;
    }
}

