/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.auditing.service;

import org.egov.infra.admin.auditing.contract.UserPasswordChangeAuditReportRequest;
import org.egov.infra.admin.auditing.contract.UserRoleChangeAuditReportRequest;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.UserRepository;
import org.egov.infra.web.support.search.DataTableSearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.history.Revision;
import org.springframework.stereotype.Service;

@Service
public class UserAuditService {
    @Autowired
    private UserRepository userRepository;

    public Page<Revision<Integer, User>> getUserRoleChangeAudit(UserRoleChangeAuditReportRequest userRoleAuditReportRequest) {
        return this.getPagedUserRevision(userRoleAuditReportRequest.getUserId(), userRoleAuditReportRequest);
    }

    public Page<Revision<Integer, User>> getUserPasswordChangeAudit(UserPasswordChangeAuditReportRequest userPasswordChangeAuditReportRequest) {
        return this.getPagedUserRevision(userPasswordChangeAuditReportRequest.getUserId(), userPasswordChangeAuditReportRequest);
    }

    public Page<Revision<Integer, User>> getPagedUserRevision(Long userId, DataTableSearchRequest dataTableSearchRequest) {
        PageRequest pageable = new PageRequest(dataTableSearchRequest.pageNumber(), dataTableSearchRequest.pageSize(), dataTableSearchRequest.orderDir(), new String[]{dataTableSearchRequest.orderBy()});
        return this.userRepository.findRevisions(userId, (Pageable)pageable);
    }
}

